//  Listing 11.2. Klasa String z dynamicznym przydziaem pamici na stercie
//  klasa String dynamicznie zapamituje tablic znakow

#include <iostream>
using namespace std;

class String 
{
char *str;             		// dynamicznie zapamituje tablic znakow
int len;
  public:
String (int length=0); 		// konstruktor domylny / konwertujcy
String(const char*); 		// konstruktor konwertujcy
~String (); 			// zwolnienie dynamicznej pamici
void modify(const char*); 	// zmiana zawartoci tablicy znakowej
char* show() const; 		// zwrot wskanika do tej tablicy
};

String::String(int length)
{ 
len = length;
str = new char[len+1]; 		// domylny rozmiar to 1
if (str==NULL) exit(1); 	// sprawd, czy si powiodo
str[0] = 0;  			// pusty acuch o dugoci 0, to jest OK
}

String::String(const char* s)
{ 
len = strlen(s); 		// zmierz dugo wczytanego tekstu
str = new char[len+1]; 		// przydziel wystarczajc ilo miejsca na stercie
if (str==NULL) exit(1); 	// sprawd, czy si powiodo
strcpy(str,s);  		// kopiuj tekst do nowego obszaru na stercie
}

String::~String()
  { delete str; } 		// zwrot pamici na stercie (nie wskanika!)

void String::modify(const char a[]) 	// adnego zarzdzania pamici
{ 
strncpy(str,a,len-1); 			// ochrona przed przepenieniem (obcinanie)
str[len-1] = 0;  			// poprawne zakoczenie acucha znakw
}

char* String::show() const 	// to nie jest zalecana praktyka, ale OK
 { return str; }

int main()
{
String u("This is a test.");
	// po spolszczeniu byoby: String u("To jest tekst.");
String v("Nothing can go wrong.");
	// po spolszczeniu byoby: String u("Nic nie moe pj le.");
cout << " u = " << u.show() << endl; 	// rezultat jest OK
cout << " v = " << v.show() << endl; 	// rezultat jest OK
	// tu nastpi obcicie nadmiarowych znakw
v.modify("Let us hope for the best."); 
	// po spolszczeniu: v.modify("Nasza nadzieja w b (po 'b' - obcicie).");
cout << " v = " << v.show() << endl;
strcpy(v.show(),"Hi there"); 		// niezalecana praktyka
	// po spolszczeniu byoby: strcpy(v.show(),"Hej tam");
cout << " v = " << v.show() << endl;
return 0;
}
